/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.qio;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.tab.GuiQIOFrequencyTab;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.registries.MekanismSounds;
import mekanism.common.tile.qio.TileEntityQIORedstoneAdapter;
import mekanism.common.util.StackUtils;
import mekanism.common.util.text.InputValidator;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class GuiQIORedstoneAdapter
extends GuiMekanismTile<TileEntityQIORedstoneAdapter, MekanismTileContainer<TileEntityQIORedstoneAdapter>> {
    private GuiTextField text;

    public GuiQIORedstoneAdapter(MekanismTileContainer<TileEntityQIORedstoneAdapter> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.dynamicSlots = true;
        this.f_97727_ += 16;
        this.f_97731_ = this.f_97727_ - 94;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiQIOFrequencyTab((IGuiWrapper)this, this.tile));
        this.addRenderableWidget(new GuiSlot(SlotType.NORMAL, this, 7, 30).setRenderHover(true)).setGhostHandler(ingredient -> {
            Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteractionItem.QIO_REDSTONE_ADAPTER_STACK, (BlockEntity)this.tile, StackUtils.size((ItemStack)ingredient, 1)));
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)MekanismSounds.BEEP.get()), (float)1.0f));
        });
        this.addRenderableWidget(new GuiInnerScreen((IGuiWrapper)this, 7, 16, this.f_97726_ - 15, 12, () -> {
            ArrayList<TranslatableComponent> list = new ArrayList<TranslatableComponent>();
            QIOFrequency freq = ((TileEntityQIORedstoneAdapter)this.tile).getQIOFrequency();
            if (freq == null) {
                list.add(MekanismLang.NO_FREQUENCY.translate(new Object[0]));
            } else {
                list.add(MekanismLang.FREQUENCY.translate(freq.getKey()));
            }
            return list;
        }).tooltip(() -> {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            QIOFrequency freq = ((TileEntityQIORedstoneAdapter)this.tile).getQIOFrequency();
            if (freq != null) {
                list.add(MekanismLang.QIO_ITEMS_DETAIL.translateColored(EnumColor.GRAY, EnumColor.INDIGO, TextUtils.format(freq.getTotalItemCount()), TextUtils.format(freq.getTotalItemCountCapacity())));
                list.add(MekanismLang.QIO_TYPES_DETAIL.translateColored(EnumColor.GRAY, EnumColor.INDIGO, TextUtils.format(freq.getTotalItemTypes(true)), TextUtils.format(freq.getTotalItemTypeCapacity())));
            }
            return list;
        }));
        this.addRenderableWidget(new GuiInnerScreen((IGuiWrapper)this, 27, 30, this.f_97726_ - 27 - 8, 54, () -> {
            ArrayList<TranslatableComponent> list = new ArrayList<TranslatableComponent>();
            list.add((TranslatableComponent)(((TileEntityQIORedstoneAdapter)this.tile).getItemType().m_41619_() ? MekanismLang.QIO_ITEM_TYPE_UNDEFINED.translate(new Object[0]) : ((TileEntityQIORedstoneAdapter)this.tile).getItemType().m_41786_()));
            list.add(MekanismLang.QIO_TRIGGER_COUNT.translate(TextUtils.format(((TileEntityQIORedstoneAdapter)this.tile).getCount())));
            if (!((TileEntityQIORedstoneAdapter)this.tile).getItemType().m_41619_() && ((TileEntityQIORedstoneAdapter)this.tile).getQIOFrequency() != null) {
                list.add(MekanismLang.QIO_STORED_COUNT.translate(TextUtils.format(((TileEntityQIORedstoneAdapter)this.tile).getStoredCount())));
            }
            return list;
        }).clearFormat());
        this.text = this.addRenderableWidget(new GuiTextField(this, 29, 70, this.f_97726_ - 39, 12));
        this.text.setMaxLength(10);
        this.text.setInputValidator(InputValidator.DIGIT);
        this.text.m_93692_(true);
        this.text.configureDigitalInput(this::setCount);
    }

    private void setCount() {
        if (!this.text.getText().isEmpty()) {
            long count = Long.parseLong(this.text.getText());
            Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.QIO_REDSTONE_ADAPTER_COUNT, (BlockEntity)this.tile, (int)Math.min(count, Integer.MAX_VALUE)));
            this.text.setText("");
        }
    }

    @Override
    protected void drawForegroundText(@Nonnull PoseStack matrix, int mouseX, int mouseY) {
        this.renderTitleText(matrix);
        this.drawString(matrix, this.f_169604_, this.f_97730_, this.f_97731_, this.titleTextColor());
        if (((TileEntityQIORedstoneAdapter)this.tile).getItemType() != null) {
            this.renderItem(matrix, ((TileEntityQIORedstoneAdapter)this.tile).getItemType(), 8, 31);
        }
        super.drawForegroundText(matrix, mouseX, mouseY);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        super.m_6375_(mouseX, mouseY, button);
        if (button == 0) {
            double xAxis = mouseX - (double)this.f_97735_;
            double yAxis = mouseY - (double)this.f_97736_;
            if (xAxis >= 8.0 && xAxis < 24.0 && yAxis >= 31.0 && yAxis < 47.0) {
                ItemStack stack = this.getMinecraft().f_91074_.f_36096_.m_142621_();
                if (!stack.m_41619_() && !GuiQIORedstoneAdapter.m_96638_()) {
                    Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteractionItem.QIO_REDSTONE_ADAPTER_STACK, (BlockEntity)this.tile, StackUtils.size(stack, 1)));
                } else if (stack.m_41619_() && GuiQIORedstoneAdapter.m_96638_()) {
                    Mekanism.packetHandler().sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteractionItem.QIO_REDSTONE_ADAPTER_STACK, (BlockEntity)this.tile, ItemStack.f_41583_));
                }
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)MekanismSounds.BEEP.get()), (float)1.0f));
            }
        }
        return true;
    }
}

